/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.text;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.BreakIterator;
import icyllis.modernui.text.CharArrayIterator;
import icyllis.modernui.text.SpannableString;
import icyllis.modernui.text.SpannedString;
import icyllis.modernui.text.TextUtils;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class GraphemeBreak {
    public static final int AFTER = 0;
    public static final int AT_OR_AFTER = 1;
    public static final int BEFORE = 2;
    public static final int AT_OR_BEFORE = 3;
    public static final int AT = 4;
    public static boolean sUseICU = true;

    private GraphemeBreak() {
    }

    public static int getTextRunCursor(@Nonnull char[] text, @Nonnull Locale locale, int contextStart, int contextLength, int offset, int op) {
        int contextEnd = contextStart + contextLength;
        if ((contextStart | contextEnd | offset | contextEnd - contextStart | offset - contextStart | contextEnd - offset | text.length - contextEnd | op) < 0 || op > 4) {
            throw new IndexOutOfBoundsException();
        }
        return sUseICU ? GraphemeBreak.getTextRunCursorICU(new CharArrayIterator(text, contextStart, contextEnd), locale, offset, op) : GraphemeBreak.getTextRunCursorImpl(null, text, contextStart, contextLength, offset, op);
    }

    public static int getTextRunCursor(@Nonnull CharSequence text, @Nonnull Locale locale, int contextStart, int contextEnd, int offset, int op) {
        if (text instanceof String || text instanceof SpannedString || text instanceof SpannableString) {
            return GraphemeBreak.getTextRunCursor(text.toString(), locale, contextStart, contextEnd, offset, op);
        }
        int contextLen = contextEnd - contextStart;
        char[] buf = new char[contextLen];
        TextUtils.getChars(text, contextStart, contextEnd, buf, 0);
        offset = GraphemeBreak.getTextRunCursor(buf, locale, 0, contextLen, offset - contextStart, op);
        return offset == -1 ? -1 : offset + contextStart;
    }

    public static int getTextRunCursor(@Nonnull String text, @Nonnull Locale locale, int contextStart, int contextEnd, int offset, int op) {
        if ((contextStart | contextEnd | offset | contextEnd - contextStart | offset - contextStart | contextEnd - offset | text.length() - contextEnd | op) < 0 || op > 4) {
            throw new IndexOutOfBoundsException();
        }
        return sUseICU ? GraphemeBreak.getTextRunCursorICU(new StringCharacterIterator(text, contextStart, contextEnd, contextStart), locale, offset, op) : GraphemeBreak.getTextRunCursorImpl(null, text.toCharArray(), contextStart, contextEnd - contextStart, offset, op);
    }

    public static void getTextRuns(@Nonnull char[] text, @Nonnull Locale locale, int contextStart, int contextEnd, @Nonnull RunConsumer consumer) {
        if (sUseICU) {
            int offset;
            BreakIterator breaker = BreakIterator.getCharacterInstance((Locale)locale);
            breaker.setText((CharacterIterator)new CharArrayIterator(text, contextStart, contextEnd));
            int prevOffset = contextStart;
            while ((offset = breaker.following(prevOffset)) != -1) {
                consumer.onRun(prevOffset, offset);
                prevOffset = offset;
            }
        } else {
            int offset;
            int count = contextEnd - contextStart;
            int prevOffset = contextStart;
            while ((offset = GraphemeBreak.getTextRunCursorImpl(null, text, contextStart, count, prevOffset, 0)) != prevOffset) {
                consumer.onRun(prevOffset, offset);
                prevOffset = offset;
            }
        }
    }

    public static int getTextRunCursorICU(CharacterIterator text, Locale locale, int offset, int op) {
        int oof = offset;
        BreakIterator breaker = BreakIterator.getCharacterInstance((Locale)locale);
        breaker.setText(text);
        switch (op) {
            case 0: {
                offset = breaker.following(offset);
                break;
            }
            case 1: {
                if (breaker.isBoundary(offset)) break;
                offset = breaker.following(offset);
                break;
            }
            case 2: {
                offset = breaker.preceding(offset);
                break;
            }
            case 3: {
                if (breaker.isBoundary(offset)) break;
                offset = breaker.preceding(offset);
                break;
            }
            case 4: {
                if (breaker.isBoundary(offset)) break;
                return -1;
            }
        }
        return offset == -1 ? oof : offset;
    }

    public static int getTextRunCursorImpl(@Nullable float[] advances, @Nonnull char[] buf, int start, int count, int offset, int op) {
        switch (op) {
            case 0: {
                if (offset < start + count) {
                    ++offset;
                }
            }
            case 1: {
                while (!GraphemeBreak.isGraphemeBreak(advances, buf, start, count, offset)) {
                    ++offset;
                }
                break;
            }
            case 2: {
                if (offset > start) {
                    --offset;
                }
            }
            case 3: {
                while (!GraphemeBreak.isGraphemeBreak(advances, buf, start, count, offset)) {
                    --offset;
                }
                break;
            }
            case 4: {
                if (GraphemeBreak.isGraphemeBreak(advances, buf, start, count, offset)) break;
                offset = -1;
            }
        }
        return offset;
    }

    public static boolean isGraphemeBreak(@Nullable float[] advances, @Nonnull char[] buf, int start, int count, int offset) {
        int c0;
        boolean c2_has_advance;
        char _c2;
        int _c1;
        if (offset <= start || offset >= start + count) {
            return true;
        }
        if (Character.isLowSurrogate(buf[offset])) {
            return !Character.isHighSurrogate(buf[offset - 1]);
        }
        int offsetBack = offset;
        int c2 = _c1 = buf[offsetBack++];
        if (Character.isHighSurrogate((char)_c1) && offsetBack != start + count && Character.isLowSurrogate(_c2 = buf[offsetBack])) {
            ++offsetBack;
            c2 = Character.toCodePoint((char)_c1, _c2);
        }
        offsetBack = offset;
        int c1 = _c1 = buf[--offsetBack];
        if (Character.isLowSurrogate((char)_c1) && offsetBack > start && Character.isHighSurrogate(_c2 = buf[offsetBack - 1])) {
            --offsetBack;
            c1 = Character.toCodePoint(_c2, (char)_c1);
        }
        int p1 = GraphemeBreak.tailoredGraphemeClusterBreak(c1);
        int p2 = GraphemeBreak.tailoredGraphemeClusterBreak(c2);
        if (p1 == 2 && p2 == 5) {
            return false;
        }
        if (p1 == 1 || p1 == 2 || p1 == 5) {
            return true;
        }
        if (p2 == 1 || p2 == 2 || p2 == 5) {
            return true;
        }
        if (p1 == 4 && (p2 == 4 || p2 == 9 || p2 == 6 || p2 == 7)) {
            return false;
        }
        if (!(p1 != 6 && p1 != 9 || p2 != 9 && p2 != 8)) {
            return false;
        }
        if ((p1 == 7 || p1 == 8) && p2 == 8) {
            return false;
        }
        boolean bl = c2_has_advance = advances != null && (double)advances[offset - start] != 0.0;
        if (c2_has_advance) {
            return true;
        }
        if (p2 == 3 || p2 == 17 || p2 == 10 || p1 == 11) {
            return false;
        }
        if (offsetBack > start && p1 == 17 && UCharacter.hasBinaryProperty((int)c2, (int)64)) {
            int offsetBack1 = offsetBack;
            c0 = _c1 = buf[--offsetBack1];
            if (Character.isLowSurrogate((char)_c1) && offsetBack1 > start && Character.isHighSurrogate(_c2 = buf[offsetBack1 - 1])) {
                --offsetBack1;
                c0 = Character.toCodePoint(_c2, (char)_c1);
            }
            int p0 = GraphemeBreak.tailoredGraphemeClusterBreak(c0);
            while (p0 == 3 && offsetBack1 > start) {
                c0 = _c1 = buf[--offsetBack1];
                if (Character.isLowSurrogate((char)_c1) && offsetBack1 > start && Character.isHighSurrogate(_c2 = buf[offsetBack1 - 1])) {
                    --offsetBack1;
                    c0 = Character.toCodePoint(_c2, (char)_c1);
                }
                p0 = GraphemeBreak.tailoredGraphemeClusterBreak(c0);
            }
            if (UCharacter.hasBinaryProperty((int)c0, (int)64)) {
                return false;
            }
        }
        if (p1 == 12 && p2 == 12) {
            if (advances != null) {
                return false;
            }
            int backBarrier = Math.max(start, offsetBack - 1000);
            int offsetBack1 = offsetBack;
            while (offsetBack1 > backBarrier) {
                c0 = _c1 = buf[--offsetBack1];
                if (Character.isLowSurrogate((char)_c1) && offsetBack1 > backBarrier && Character.isHighSurrogate(_c2 = buf[offsetBack1 - 1])) {
                    --offsetBack1;
                    c0 = Character.toCodePoint(_c2, (char)_c1);
                }
                if (GraphemeBreak.tailoredGraphemeClusterBreak(c0) == 12) continue;
                offsetBack1 += Character.charCount(c0);
                break;
            }
            return (offset - offsetBack1) % 4 == 0;
        }
        return UCharacter.getIntPropertyValue((int)c1, (int)4098) != 9 || GraphemeBreak.isPureKiller(c1) || UCharacter.getIntPropertyValue((int)c2, (int)4101) != 5;
    }

    public static boolean isPureKiller(int c) {
        return c == 3642 || c == 3662 || c == 3972 || c == 4154 || c == 5908 || c == 5940 || c == 6097 || c == 7082 || c == 7154 || c == 7155 || c == 43014 || c == 43347 || c == 44013 || c == 69940 || c == 70378 || c == 71467;
    }

    public static int tailoredGraphemeClusterBreak(int c) {
        if (c == 173 || c == 1564 || c == 6158 || c == 8203 || c == 8206 || c == 8207 || 8234 <= c && c <= 8238 || (c | 0xF) == 8303 || c == 65279 || (c | 0x7F) == 917631) {
            return 3;
        }
        if (c == 3635) {
            return 0;
        }
        return UCharacter.getIntPropertyValue((int)c, (int)4114);
    }

    @FunctionalInterface
    public static interface RunConsumer {
        public void onRun(int var1, int var2);
    }
}

